package Teken.TekensAPI;

import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;

import org.w3c.dom.Document;
import org.w3c.dom.NodeList;
import org.w3c.dom.Node;
import org.w3c.dom.Element;

import net.minecraft.client.Minecraft;

public class VersionCheckerAPI
{
    static Minecraft minecraft;

    public static void checkerSimpleSSP(String name, double version , String versiondoc, String download, Minecraft mc)
    {
        minecraft = mc;
        System.out.println("");
        System.out.println("==================================================");
        System.out.println("");
        System.out.println("Welcome to Teken's Mod Version Checker");
        System.out.println("Checking if " + name + " is up-to-date");

        try
        {
            URL url = new URL(versiondoc);
            BufferedReader in = new BufferedReader(new InputStreamReader(url.openStream()));
            String str;
            double newversion = 0;

            while ((str = in.readLine()) != null)
            {
                if (str.contains("Version"))
                {
                    newversion = Double.parseDouble(str.replaceAll("Version:", "").trim());
                    break;
                }
            }

            if (newversion > version)
            {
                System.out.println(name + " is out-of-date");
                window(name, download);
            }
            else
            {
                System.out.println(name + " is up-to-date");
            }

            in.close();
        }
        catch (MalformedURLException e)
        {
        }
        catch (IOException e)
        {
        }

        System.out.println("");
        System.out.println("==================================================");
        System.out.println("");
    }

    public static void checkerXMLSSP(String name, double version , String versiondoc, String download, Minecraft mc)
    {
        minecraft = mc;
        System.out.println("");
        System.out.println("==================================================");
        System.out.println("");
        System.out.println("Welcome to Teken's Mod Version Checker");
        System.out.println("Checking if " + name + " is up-to-date");

        try
        {
            URL url = new URL(versiondoc);
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.parse(url.openStream());
            doc.getDocumentElement().normalize();
            NodeList nList = doc.getElementsByTagName(name.replace(" ", "").trim());
            String nValue = "";

            for (int temp = 0; temp < nList.getLength(); temp++)
            {
                Node nNode = nList.item(temp);

                if (nNode.getNodeType() == Node.ELEMENT_NODE)
                {
                    Element eElement = (Element) nNode;
                    nValue = eElement.getElementsByTagName("version").item(0).getChildNodes().item(0).getNodeValue();
                }
            }

            double newversion = Double.parseDouble(nValue);

            if (newversion > version)
            {
                System.out.println(name + " is out-of-date");
                window(name, download);
            }
            else
            {
                System.out.println(name + " is up-to-date");
            }
        }
        catch (Exception e)
        {
            e.printStackTrace();
        }

        System.out.println("");
        System.out.println("==================================================");
        System.out.println("");
    }

    private static void window(String name, String download)
    {
        String url2 = download;
        JFrame frame32 = new JFrame();
        frame32.setVisible(true);
        frame32.setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

        if (JOptionPane.showConfirmDialog(frame32, name + " is out-of-date, would you like to update now?", "Teken's Update Checker", JOptionPane.OK_CANCEL_OPTION) == 0)
        {
            frame32.setVisible(false);
            frame32.dispose();
            minecraft.shutdown();

            try
            {
                java.awt.Desktop.getDesktop().browse(java.net.URI.create(url2));
            }
            catch (IOException e)
            {
                e.printStackTrace();
            }
        }
        else
        {
            frame32.setVisible(false);
            frame32.dispose();
        }
    }
}
