package Teken.TekensAPI;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Properties;

public class PropertiesAPI
{
	private static Properties props;
	private static File file;
	private static String maintitle;
	private static boolean exists;
	private static String finalpath;

	public static void initialiseProperties(String path, String filename, String title)
	{
		System.out.println("");
		System.out.println("==================================================");
		System.out.println("");
		System.out.println("Welcome to Teken's Properties API");
		System.out.println("");
		filePathFix(path, filename);
		props = new Properties();

		if (!doesPropertieFileExist(path, filename))
		{
			setFile(path, filename);
			setTitle(title);
			try {
				file.createNewFile();
			} catch (IOException e) {
				e.printStackTrace();
			}
		}
		else
		{
			exists = true;
		}

		System.out.println("Initialise properties for " + finalpath);
	}

	private static void setFile(String path, String filename)
	{
		file = new File((new StringBuilder()).append(getCurrentPath()).append(finalpath).toString());
		System.out.println((new StringBuilder()).append(getCurrentPath()).append(finalpath).toString());
	}

	private static void filePathFix(String path, String filename)
	{
		if (path == null)
		{
			finalpath = filename;
		}
		else
		{
			finalpath = path + filename;
		}

		System.out.println("File path generated");
		System.out.println(finalpath);
	}

	private static void setTitle(String title)
	{
		maintitle = title;
	}

	private boolean existCheck()
	{
		if (exists)
		{
			return true;
		}
		else
		{
			System.out.println("Couldn't find file " + finalpath);
			return false;
		}
	}

	private static boolean doesPropertieFileExist(String path, String filename)
	{
		try
		{
			setFile(path, filename);

			if (file.exists() && file.canRead())
			{
				props.load(new FileInputStream(file));
				return true;
			}
			else
			{
				return false;
			}
		}
		catch (IOException ioexception)
		{
			ioexception.printStackTrace();
			return false;
		}
	}

	private static String getCurrentPath()
	{
		File dir1 = new File(".");

		try
		{
			String path = dir1.getCanonicalPath();
			return path;
		}
		catch (Exception e)
		{
			e.printStackTrace();
			return "";
		}
	}

	public static String propertieString(String varableName, String varableValue)
	{
		System.out.println("Loading " + varableName + " propertie");

		propertieCheck( varableName, varableValue);

		String value = props.getProperty(varableName, varableValue);
		System.out.println(varableName + " propertie has been loaded");
		return value;
	}

	public static int propertieInt(String varableName, String varableValue)
	{
		System.out.println("Loading " + varableName + " propertie");

		propertieCheck( varableName, varableValue);

		int value = Integer.parseInt(props.getProperty(varableName, varableValue));
		System.out.println(varableName + " propertie has been loaded");
		return value;
	}

	public static float propertieFloat(String varableName, String varableValue)
	{
		System.out.println("Loading " + varableName + " propertie");

		propertieCheck( varableName, varableValue);

		float value = Float.parseFloat(props.getProperty(varableName, varableValue));
		System.out.println(varableName + " propertie has been loaded");
		return value;
	}

	public static double propertieDouble(String varableName, String varableValue)
	{
		System.out.println("Loading " + varableName + " propertie");

		propertieCheck( varableName, varableValue);

		double value = Double.parseDouble(props.getProperty(varableName, varableValue));
		System.out.println(varableName + " propertie has been loaded");
		return value;
	}

	public static byte propertieByte(String varableName, String varableValue)
	{
		System.out.println("Loading " + varableName + " propertie");

		propertieCheck( varableName, varableValue);

		byte value = Byte.parseByte(props.getProperty(varableName, varableValue));
		System.out.println(varableName + " propertie has been loaded");
		return value;
	}

	public static boolean propertieBoolean(String varableName, String varableValue)
	{
		System.out.println("Loading " + varableName + " propertie");

		propertieCheck( varableName, varableValue);

		boolean value = Boolean.parseBoolean(props.getProperty(varableName, varableValue));
		System.out.println(varableName + " propertie has been loaded");
		return value;
	}

	public static long propertieLong(String varableName, String varableValue)
	{
		System.out.println("Loading " + varableName + " propertie");
		
		propertieCheck( varableName, varableValue);
		
		long value = Long.parseLong(props.getProperty(varableName, varableValue));
		System.out.println(varableName + " propertie has been loaded");
		return value;
	}
	
	private static void propertieCheck(String varableName, String varableValue){
		if (props.getProperty(varableName) == null)
		{
			System.out.println(varableName + " propertie couldn't be found, so it was created");
			props.put(varableName, varableValue);
		}
	}

	public static void finaliseProperties()
	{
		System.out.println("Finalising properties");

		try
		{
			props.store(new FileOutputStream(file), maintitle);
			System.out.println("Properties finalised");
		}
		catch (Exception exception) {}

		System.out.println("");
		System.out.println("==================================================");
		System.out.println("");
	}
}
