/*
 * Decompiled with CFR 0.152.
 */
package eb.mode;

import eb.core.Direction;
import eb.core.EBHelper;
import eb.core.handlers.GhostHandler;
import eb.core.mode.GhostMode;
import eb.macro.Macro;
import eb.macro.instruction.MoveInstruction;
import eb.macro.instruction.UseInstruction;
import eb.network.packet.PacketPlaceBlock;

public class BuildMode
extends GhostMode {
    @Override
    public UseInstruction use() {
        ur currentItem;
        if (this.isGhostPlaced() && (currentItem = EBHelper.getCurrentItem()) != null) {
            return this.use(currentItem.c, currentItem.j());
        }
        return null;
    }

    public UseInstruction use(int itemID, int itemMetadata) {
        if (this.isGhostPlaced()) {
            EBHelper.sendToServer(new PacketPlaceBlock(this.x, this.y, this.z, itemID, itemMetadata));
            return new BuildUseInstruction(itemID, itemMetadata);
        }
        return null;
    }

    @Override
    public boolean allowsMacros() {
        return true;
    }

    public static Macro translateRawData(short width, short length, short height, byte[] blocks, byte[] meta) {
        Macro macro = new Macro(BuildMode.class);
        boolean leftToRight = true;
        boolean progress = false;
        for (int y2 = 0; y2 < height; ++y2) {
            for (int z2 = 0; z2 < length; ++z2) {
                for (int x = leftToRight ? 0 : width - 1; x != (leftToRight ? width : -1); x += leftToRight ? 1 : -1) {
                    int index = y2 * width * length + z2 * width + x;
                    if (blocks[index] != 0) {
                        macro.addInstruction(new BuildUseInstruction(blocks[index], meta[index]));
                    }
                    if (leftToRight && x != width - 1) {
                        macro.addInstruction(new MoveInstruction(Direction.RIGHT));
                        continue;
                    }
                    if (leftToRight || x == 0) continue;
                    macro.addInstruction(new MoveInstruction(Direction.LEFT));
                }
                leftToRight = !leftToRight;
                macro.addInstruction(new MoveInstruction(Direction.FORWARD));
            }
            macro.addInstruction(new MoveInstruction(Direction.UP));
            for (int i = 0; i < length; ++i) {
                macro.addInstruction(new MoveInstruction(Direction.BACKWARD));
            }
        }
        return macro;
    }

    public static class BuildUseInstruction
    extends UseInstruction {
        private int itemID;
        private int itemMetadata;

        public BuildUseInstruction() {
            this(0, 0);
        }

        public BuildUseInstruction(int itemID, int itemMetadata) {
            this.itemID = itemID;
            this.itemMetadata = itemMetadata;
        }

        @Override
        public void execute() {
            GhostMode mode = GhostHandler.instance().getMode();
            if (!(mode instanceof BuildMode)) {
                return;
            }
            ((BuildMode)mode).use(this.itemID, this.itemMetadata);
        }

        @Override
        public String[] getParameters() {
            return new String[]{Integer.toString(this.itemID), Integer.toString(this.itemMetadata)};
        }

        @Override
        public boolean parseParameters(String[] parameters) {
            try {
                this.itemID = Integer.parseInt(parameters[0]);
                this.itemMetadata = Integer.parseInt(parameters[1]);
            }
            catch (Exception e) {
                return false;
            }
            return true;
        }
    }
}

