/*
 * Decompiled with CFR 0.152.
 */
package eb.macro;

import eb.macro.Macro;
import eb.mode.BuildMode;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.zip.GZIPInputStream;

public class SchematicImporter {
    private Macro macro = null;

    public Macro getMacro() {
        return this.macro;
    }

    public void importSchematic(String path) {
        DataInputStream input = this.getSchematicStream(path);
        try {
            bq base = (bq)cd.b((DataInput)input);
            short width = base.d("Width");
            short length = base.d("Length");
            short height = base.d("Height");
            this.macro = BuildMode.translateRawData(width, length, height, base.j("Blocks"), base.j("Data"));
            this.macro.setName(this.getFileName(path));
            this.macro.setDescription("Imported from " + path);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private DataInputStream getSchematicStream(String path) {
        try {
            return new DataInputStream(new GZIPInputStream(new FileInputStream(path)));
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getFileName(String path) {
        int start = path.lastIndexOf(File.separatorChar);
        int end = path.lastIndexOf(46);
        if (start == -1) {
            start = 0;
        }
        if (end == -1) {
            end = path.length();
        }
        return path.substring(start + 1, end);
    }
}

