/*
 * Decompiled with CFR 0.152.
 */
package eb.macro;

import eb.core.Constants;
import eb.macro.Macro;
import eb.macro.instruction.IInstruction;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class MacroIO {
    private static Map loadedMacros = new HashMap();

    public static boolean save(Macro macro) {
        try {
            String path = MacroIO.getMacroPath(macro.getName());
            FileOutputStream fileOS = new FileOutputStream(path);
            DataOutputStream dataOS = new DataOutputStream(fileOS);
            bq instructionsTag = new bq();
            LinkedList instructions = macro.getInstructions();
            for (int i = 0; i < instructions.size(); ++i) {
                instructionsTag.a("instruction" + i, MacroIO.instructionToTag((IInstruction)instructions.get(i)));
            }
            instructionsTag.a("size", instructions.size());
            bq macroTag = new bq();
            macroTag.a("requiredMode", macro.getRequiredMode().getName());
            macroTag.a("name", macro.getName());
            macroTag.a("description", macro.getDescription());
            macroTag.a("instructions", instructionsTag);
            cd.a((cd)macroTag, (DataOutput)dataOS);
            dataOS.close();
            fileOS.close();
            loadedMacros.put(path, macro);
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static Macro load(String name) {
        String path = MacroIO.getMacroPath(name);
        Macro requested = null;
        requested = (Macro)loadedMacros.get(path);
        if (requested != null) {
            return requested;
        }
        try {
            return MacroIO.loadFromNBT(path);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static boolean macroExists(String name) {
        String path = MacroIO.getMacroPath(name);
        File file = new File(path);
        return file.exists();
    }

    public static void setUpDirectories() {
        String[] directories;
        for (String directory : directories = new String[]{Constants.MACROS_PATH, Constants.SCHEMATICS_PATH}) {
            File file = new File(directory);
            if (file.exists()) continue;
            file.mkdirs();
        }
    }

    private static String getMacroPath(String name) {
        return Constants.MACROS_PATH + File.separator + name.trim().replace(" ", "_") + ".macro";
    }

    private static bq instructionToTag(IInstruction instruction) {
        bq instructionTag = new bq();
        instructionTag.a("class", instruction.getClass().getName());
        String[] parameters = instruction.getParameters();
        if (parameters != null) {
            instructionTag.a("numParameters", parameters.length);
            for (int i = 0; i < parameters.length; ++i) {
                instructionTag.a("parameter" + i, parameters[i]);
            }
        }
        return instructionTag;
    }

    private static Macro loadFromNBT(String path) throws IOException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        FileInputStream fileIS = new FileInputStream(path);
        DataInputStream dataIS = new DataInputStream(fileIS);
        bq macroTag = (bq)cd.b((DataInput)dataIS);
        String name = macroTag.i("name");
        String description = macroTag.i("description");
        bq instructions = macroTag.l("instructions");
        int numInstructions = instructions.e("size");
        Macro macro = new Macro(MacroIO.getRequriedModeFromName(macroTag.i("requiredMode")));
        macro.setName(name);
        macro.setDescription(description);
        for (int i = 0; i < numInstructions; ++i) {
            bq instructionTag = instructions.l("instruction" + i);
            String instructionClassName = instructionTag.i("class");
            Class<?> instructionClass = Class.forName(instructionClassName);
            if (!IInstruction.class.isAssignableFrom(instructionClass)) continue;
            IInstruction instruction = (IInstruction)instructionClass.newInstance();
            if (instruction == null) {
                dataIS.close();
                fileIS.close();
                return null;
            }
            String[] params = MacroIO.convertTagToParameters(instructionTag);
            if (instruction.parseParameters(params)) {
                macro.addInstruction(instruction);
                continue;
            }
            dataIS.close();
            fileIS.close();
            return null;
        }
        dataIS.close();
        fileIS.close();
        return macro;
    }

    private static Class getRequriedModeFromName(String name) throws ClassNotFoundException {
        return Class.forName(name);
    }

    private static String[] convertTagToParameters(bq instructionTag) {
        int numParams = instructionTag.e("numParameters");
        String[] parameters = new String[numParams];
        for (int i = 0; i < numParams; ++i) {
            parameters[i] = instructionTag.i("parameter" + i);
        }
        return parameters;
    }

    static {
        MacroIO.setUpDirectories();
    }
}

