/*
 * Decompiled with CFR 0.152.
 */
package eb.macro;

import eb.core.handlers.GhostKeyHandler;
import eb.macro.instruction.IInstruction;
import eb.macro.instruction.MoveInstruction;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Observable;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

public class Macro
extends Observable
implements Runnable {
    private static final int PLAYBACK_SPEED = 10;
    private Class requiredMode;
    private String name;
    private String description;
    private LinkedList instructions;
    private Iterator iterator;
    private boolean playing;
    private ScheduledExecutorService scheduler;

    public Macro() {
        this(null);
    }

    public Macro(Class mode) {
        this.requiredMode = mode;
        this.name = "Unnamed";
        this.description = "No Description";
        this.instructions = new LinkedList();
        this.iterator = null;
        this.playing = false;
        this.scheduler = Executors.newScheduledThreadPool(1);
    }

    public Class getRequiredMode() {
        return this.requiredMode;
    }

    public void addInstruction(IInstruction instruction) {
        this.instructions.add(instruction);
    }

    public void play() {
        if (this.instructions.isEmpty()) {
            return;
        }
        this.playing = true;
        this.iterator = this.instructions.iterator();
        GhostKeyHandler.setControl(false);
        this.run();
    }

    public void stop() {
        this.playing = false;
        this.iterator = null;
        GhostKeyHandler.setControl(true);
    }

    @Override
    public void run() {
        if (this.playing && this.iterator != null && this.iterator.hasNext()) {
            IInstruction current = (IInstruction)this.iterator.next();
            current.execute();
            this.scheduler.schedule(this, 10L, TimeUnit.MILLISECONDS);
        } else {
            this.stop();
        }
    }

    public LinkedList getInstructions() {
        return this.instructions;
    }

    public IInstruction getLastInstruction() {
        if (this.instructions.size() > 0) {
            return (IInstruction)this.instructions.getLast();
        }
        return null;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isPlaying() {
        return this.playing;
    }

    public void optimize() {
        int index = 0;
        int moveSequenceStart = 0;
        while (moveSequenceStart != -1) {
            index = moveSequenceStart;
            if (index < 0) {
                index = 0;
            } else if (index >= this.instructions.size()) {
                return;
            }
            for (int i = index; i < this.instructions.size() - 1; ++i) {
                MoveInstruction current = this.getMoveInstructionAt(i);
                MoveInstruction next = this.getMoveInstructionAt(i + 1);
                MoveInstruction peek = this.getMoveInstructionAt(i + 2);
                if (current != null && next != null) {
                    if (moveSequenceStart == -1) {
                        moveSequenceStart = i;
                    }
                    if (next.getDirection().isOpposite(current.getDirection())) {
                        this.instructions.remove(i + 1);
                        this.instructions.remove(i);
                        break;
                    }
                    if (peek != null && peek.getDirection().isOpposite(current.getDirection())) {
                        this.instructions.remove(i + 2);
                        this.instructions.remove(i);
                        break;
                    }
                } else {
                    moveSequenceStart = -1;
                }
                if (i + 1 != this.instructions.size() - 1) continue;
                moveSequenceStart = -1;
            }
            this.notifyProgress(moveSequenceStart, this.instructions.size());
        }
    }

    public double getRuntime() {
        double milliseconds = this.instructions.size() * 10;
        return milliseconds / 1000.0;
    }

    private MoveInstruction getMoveInstructionAt(int index) {
        if (index < 0 || index >= this.instructions.size()) {
            return null;
        }
        IInstruction instruction = (IInstruction)this.instructions.get(index);
        if (instruction instanceof MoveInstruction) {
            return (MoveInstruction)instruction;
        }
        return null;
    }

    private void notifyProgress(int progress, int maxProgress) {
        this.setChanged();
        this.notifyObservers(Float.valueOf((float)progress / (float)maxProgress));
    }
}

