/*
 * Decompiled with CFR 0.152.
 */
package eb.core.mode;

import eb.core.Direction;
import eb.core.EBHelper;
import eb.macro.instruction.MoveInstruction;
import eb.macro.instruction.UseInstruction;
import org.lwjgl.opengl.GL11;

public abstract class GhostMode {
    protected final float[] DEFAULT_COLOUR = new float[]{1.0f, 1.0f, 1.0f, 0.5f};
    protected int x;
    protected int y;
    protected int z;
    protected boolean ghostPlaced;
    protected boolean recording;
    private aoj lockedDirection;

    public void setGhostPlaced(boolean placed) {
        this.ghostPlaced = placed;
    }

    public boolean isGhostPlaced() {
        return this.ghostPlaced;
    }

    public void setGhostPosition(int x, int y2, int z2) {
        this.x = x;
        this.y = y2;
        this.z = z2;
    }

    public int getGhostX() {
        return this.x;
    }

    public int getGhostY() {
        return this.y;
    }

    public int getGhostZ() {
        return this.z;
    }

    public void setLockedDirection(aoj direction) {
        this.lockedDirection = direction;
    }

    public MoveInstruction move(Direction direction) {
        if (this.isGhostPlaced()) {
            this.moveBy(direction, 1);
            return new MoveInstruction(direction);
        }
        return null;
    }

    public abstract UseInstruction use();

    public abstract boolean allowsMacros();

    public void render(float partialTicks) {
        if (!this.isGhostPlaced()) {
            return;
        }
        float size = 1.1f;
        double[] min = new double[]{0.0, 0.0, 0.0};
        double[] max = new double[]{size, size, size};
        float centering = (size - 1.0f) / 2.0f;
        GL11.glDisable((int)3553);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)this.x - centering), (float)((float)this.y - centering), (float)((float)this.z - centering));
        this.applyWorldTranslation(partialTicks);
        baz tess = baz.a;
        tess.b();
        tess.a(this.DEFAULT_COLOUR[0], this.DEFAULT_COLOUR[1], this.DEFAULT_COLOUR[2], this.DEFAULT_COLOUR[3]);
        this.renderTopFace(min, max);
        this.renderBottomFace(min, max);
        this.renderFrontFace(min, max);
        this.renderBackFace(min, max);
        this.renderLeftFace(min, max);
        this.renderRightFace(min, max);
        tess.a();
        GL11.glColor3f((float)0.0f, (float)0.0f, (float)0.0f);
        GL11.glBegin((int)3);
        this.renderTopFaceOutline(min, max);
        this.renderBottomFaceOutline(min, max);
        this.renderFrontFaceOutline(min, max);
        this.renderBackFaceOutline(min, max);
        this.renderLeftFaceOutline(min, max);
        this.renderRightFaceOutline(min, max);
        GL11.glEnd();
        GL11.glDisable((int)3042);
        GL11.glEnable((int)3553);
        GL11.glPopMatrix();
    }

    protected final void applyWorldTranslation(float partialTicks) {
        ays player = EBHelper.getPlayer();
        double xOffset = player.T + (player.t - player.T) * (double)partialTicks;
        double yOffset = player.U + (player.u - player.U) * (double)partialTicks;
        double zOffset = player.V + (player.v - player.V) * (double)partialTicks;
        GL11.glTranslated((double)(-xOffset), (double)(-yOffset), (double)(-zOffset));
    }

    protected final void moveBy(Direction direction, int amount) {
        if (this.isGhostPlaced()) {
            ays player = EBHelper.getPlayer();
            yc world = EBHelper.getWorld();
            aoj moveDirection = null;
            moveDirection = this.lockedDirection != null ? this.relativeToAbsoluteDirection(this.lockedDirection, direction) : this.relativeToAbsoluteDirection(EBHelper.getPlayerDirection((qx)player), direction);
            this.setGhostPosition(this.x + (int)moveDirection.c * amount, this.y + (int)moveDirection.d * amount, this.z + (int)moveDirection.e * amount);
        }
    }

    protected final aoj relativeToAbsoluteDirection(aoj forward, Direction direction) {
        aoj result = aoj.a((double)forward.c, (double)forward.d, (double)forward.e);
        if (direction == Direction.BACKWARD) {
            result.b((float)Math.PI);
        } else if (direction == Direction.LEFT) {
            result.b(1.5707964f);
        } else if (direction == Direction.RIGHT) {
            result.b(-1.5707964f);
        } else if (direction == Direction.UP) {
            result = aoj.a((double)0.0, (double)1.0, (double)0.0);
        } else if (direction == Direction.DOWN) {
            result = aoj.a((double)0.0, (double)-1.0, (double)0.0);
        }
        return result;
    }

    protected void renderTopFace(double[] min, double[] max) {
        double[][] minMax = this.correctMinMax(min, max);
        min = minMax[0];
        max = minMax[1];
        baz t = baz.a;
        t.b(0.0f, 1.0f, 0.0f);
        t.a(min[0], max[1], min[2]);
        t.a(min[0], max[1], max[2]);
        t.a(max[0], max[1], max[2]);
        t.a(max[0], max[1], min[2]);
    }

    protected void renderTopFaceOutline(double[] min, double[] max) {
        GL11.glVertex3d((double)min[0], (double)max[1], (double)min[2]);
        GL11.glVertex3d((double)min[0], (double)max[1], (double)max[2]);
        GL11.glVertex3d((double)max[0], (double)max[1], (double)max[2]);
        GL11.glVertex3d((double)max[0], (double)max[1], (double)min[2]);
        GL11.glVertex3d((double)min[0], (double)max[1], (double)min[2]);
    }

    protected void renderBottomFace(double[] min, double[] max) {
        double[][] minMax = this.correctMinMax(min, max);
        min = minMax[0];
        max = minMax[1];
        baz t = baz.a;
        t.b(0.0f, -1.0f, 0.0f);
        t.a(min[0], min[1], min[2]);
        t.a(max[0], min[1], min[2]);
        t.a(max[0], min[1], max[2]);
        t.a(min[0], min[1], max[2]);
    }

    protected void renderBottomFaceOutline(double[] min, double[] max) {
        GL11.glVertex3d((double)min[0], (double)min[1], (double)min[2]);
        GL11.glVertex3d((double)max[0], (double)min[1], (double)min[2]);
        GL11.glVertex3d((double)max[0], (double)min[1], (double)max[2]);
        GL11.glVertex3d((double)min[0], (double)min[1], (double)max[2]);
        GL11.glVertex3d((double)min[0], (double)min[1], (double)min[2]);
    }

    protected void renderFrontFace(double[] min, double[] max) {
        double[][] minMax = this.correctMinMax(min, max);
        min = minMax[0];
        max = minMax[1];
        baz t = baz.a;
        t.b(0.0f, 0.0f, 1.0f);
        t.a(min[0], min[1], min[2]);
        t.a(min[0], min[1], max[2]);
        t.a(min[0], max[1], max[2]);
        t.a(min[0], max[1], min[2]);
    }

    protected void renderFrontFaceOutline(double[] min, double[] max) {
        GL11.glVertex3d((double)min[0], (double)min[1], (double)min[2]);
        GL11.glVertex3d((double)min[0], (double)min[1], (double)max[2]);
        GL11.glVertex3d((double)min[0], (double)max[1], (double)max[2]);
        GL11.glVertex3d((double)min[0], (double)max[1], (double)min[2]);
        GL11.glVertex3d((double)min[0], (double)min[1], (double)min[2]);
    }

    protected void renderBackFace(double[] min, double[] max) {
        double[][] minMax = this.correctMinMax(min, max);
        min = minMax[0];
        max = minMax[1];
        baz t = baz.a;
        t.b(0.0f, 0.0f, -1.0f);
        t.a(max[0], min[1], min[2]);
        t.a(max[0], max[1], min[2]);
        t.a(max[0], max[1], max[2]);
        t.a(max[0], min[1], max[2]);
    }

    protected void renderBackFaceOutline(double[] min, double[] max) {
        GL11.glVertex3d((double)max[0], (double)min[1], (double)min[2]);
        GL11.glVertex3d((double)max[0], (double)max[1], (double)min[2]);
        GL11.glVertex3d((double)max[0], (double)max[1], (double)max[2]);
        GL11.glVertex3d((double)max[0], (double)min[1], (double)max[2]);
        GL11.glVertex3d((double)max[0], (double)min[1], (double)min[2]);
    }

    protected void renderLeftFace(double[] min, double[] max) {
        double[][] minMax = this.correctMinMax(min, max);
        min = minMax[0];
        max = minMax[1];
        baz t = baz.a;
        t.b(1.0f, 0.0f, 0.0f);
        t.a(min[0], min[1], max[2]);
        t.a(max[0], min[1], max[2]);
        t.a(max[0], max[1], max[2]);
        t.a(min[0], max[1], max[2]);
    }

    protected void renderLeftFaceOutline(double[] min, double[] max) {
        GL11.glVertex3d((double)min[0], (double)min[1], (double)max[2]);
        GL11.glVertex3d((double)max[0], (double)min[1], (double)max[2]);
        GL11.glVertex3d((double)max[0], (double)max[1], (double)max[2]);
        GL11.glVertex3d((double)min[0], (double)max[1], (double)max[2]);
        GL11.glVertex3d((double)min[0], (double)min[1], (double)max[2]);
    }

    protected void renderRightFace(double[] min, double[] max) {
        double[][] minMax = this.correctMinMax(min, max);
        min = minMax[0];
        max = minMax[1];
        baz t = baz.a;
        t.b(-1.0f, 0.0f, 0.0f);
        t.a(min[0], min[1], min[2]);
        t.a(min[0], max[1], min[2]);
        t.a(max[0], max[1], min[2]);
        t.a(max[0], min[1], min[2]);
    }

    protected void renderRightFaceOutline(double[] min, double[] max) {
        GL11.glVertex3d((double)min[0], (double)min[1], (double)min[2]);
        GL11.glVertex3d((double)min[0], (double)max[1], (double)min[2]);
        GL11.glVertex3d((double)max[0], (double)max[1], (double)min[2]);
        GL11.glVertex3d((double)max[0], (double)min[1], (double)min[2]);
        GL11.glVertex3d((double)min[0], (double)min[1], (double)min[2]);
    }

    private double[][] correctMinMax(double[] min, double[] max) {
        double[][] minMax = new double[][]{new double[3], new double[3]};
        minMax[0][0] = Math.min(min[0], max[0]);
        minMax[0][1] = Math.min(min[1], max[1]);
        minMax[0][2] = Math.min(min[2], max[2]);
        minMax[1][0] = Math.max(min[0], max[0]);
        minMax[1][1] = Math.max(min[1], max[1]);
        minMax[1][2] = Math.max(min[2], max[2]);
        return minMax;
    }
}

