/*
 * Decompiled with CFR 0.152.
 */
package eb.core.handlers;

import eb.client.gui.GuiMacro;
import eb.client.gui.GuiMenu;
import eb.client.gui.GuiSchematic;
import eb.core.Direction;
import eb.core.EBHelper;
import eb.core.mode.GhostMode;
import eb.macro.Macro;
import eb.macro.instruction.IInstruction;
import eb.mode.BuildMode;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.event.ForgeSubscribe;

public class GhostHandler {
    private static GhostHandler INSTANCE = new GhostHandler();
    private Macro macro;
    private boolean autoplace = false;
    private boolean recording = false;
    private GuiMenu menu;
    private GhostMode mode = new BuildMode();

    private GhostHandler() {
        this.menu = new GuiMenu(EBHelper.getClient());
        this.menu.addScreen("Load/Save Macro", new GuiMacro());
        this.menu.addScreen("Import Schematic", new GuiSchematic());
    }

    public static GhostHandler instance() {
        return INSTANCE;
    }

    @ForgeSubscribe
    public void render(RenderWorldLastEvent event) {
        this.mode.render(event.partialTicks);
    }

    public GhostMode getMode() {
        return this.mode;
    }

    public void move(Direction direction) {
        if (this.macro != null && !this.macro.isPlaying()) {
            this.mode.setLockedDirection(null);
        }
        this.addInstruction(this.mode.move(direction));
    }

    public void place() {
        aoh target = EBHelper.getClient().x;
        if (target != null) {
            int[] pos = EBHelper.getPosition(target.b, target.c, target.d, target.e);
            this.mode.setGhostPosition(pos[0], pos[1], pos[2]);
            this.mode.setGhostPlaced(true);
        }
    }

    public void use() {
        this.addInstruction(this.mode.use());
    }

    public void toggleRecording() {
        if (this.mode.allowsMacros()) {
            boolean bl = this.recording = !this.recording;
            if (this.recording) {
                EBHelper.printMessage("Started Recording");
                this.macro = new Macro(this.mode.getClass());
            } else {
                EBHelper.printMessage("Finished Recording");
                this.macro.optimize();
            }
        }
    }

    public void playMacro() {
        if (this.recording) {
            EBHelper.printMessage("You must stop recording before you can play the macro.");
            return;
        }
        if (this.macro != null) {
            if (!this.macro.isPlaying()) {
                this.mode.setLockedDirection(EBHelper.getPlayerDirection((qx)EBHelper.getPlayer()));
                this.macro.play();
            } else {
                this.macro.stop();
            }
        }
    }

    public void openMacroGui() {
        if (EBHelper.getPlayer() == null || EBHelper.getClient().r != null) {
            return;
        }
        EBHelper.getClient().a((aul)this.menu);
    }

    public void setMacro(Macro macro) {
        if (macro != null) {
            this.macro = macro;
            EBHelper.printMessage("Macro changed to \"" + macro.getName() + "\"");
            EBHelper.printMessage(macro.getName() + " has a " + macro.getRuntime() + " second runtime");
        }
    }

    public Macro getMacro() {
        return this.macro;
    }

    private void addInstruction(IInstruction instruction) {
        if (this.recording && this.macro != null && instruction != null) {
            this.macro.addInstruction(instruction);
        }
    }
}

