/*
 * Decompiled with CFR 0.152.
 */
package eb.core.gui;

import cpw.mods.fml.client.FMLClientHandler;
import eb.core.gui.GuiComponent;
import eb.core.gui.GuiHelper;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;

public class GuiWindow
extends GuiComponent {
    private static final int[][] TOP_LEFT_CORNER = new int[][]{{0, 8}, {0, 8}};
    private static final int[][] TOP_RIGHT_CORNER = new int[][]{{8, 16}, {0, 8}};
    private static final int[][] BOTTOM_LEFT_CORNER = new int[][]{{0, 8}, {8, 16}};
    private static final int[][] BOTTOM_RIGHT_CORNER = new int[][]{{8, 16}, {8, 16}};
    private static final int[][] TOP_EDGE = new int[][]{{4, 5}, {0, 8}};
    private static final int[][] LEFT_EDGE = new int[][]{{0, 8}, {4, 5}};
    private static final int[][] BOTTOM_EDGE = new int[][]{{4, 5}, {8, 16}};
    private static final int[][] RIGHT_EDGE = new int[][]{{8, 16}, {4, 5}};
    private static final int TEXTURE_SIZE = 16;
    private static final int[] WINDOW_COLOUR = new int[]{198, 198, 198};
    private Minecraft mc = FMLClientHandler.instance().getClient();
    private ArrayList components = new ArrayList();

    public GuiWindow(int width, int height) {
        this(0, 0, width, height);
        this.centerOnScreen();
    }

    public GuiWindow(int x, int y2, int width, int height) {
        super(x, y2, width, height);
    }

    @Override
    public void draw() {
        if (!this.isVisible()) {
            return;
        }
        int texture = this.mc.o.b("/eb/gui/window.png");
        this.mc.o.b(texture);
        int edgeWidth = this.getEdgeWidth();
        int edgeHeight = this.getEdgeHeight();
        this.drawEdges();
        this.drawCorner(this.x, this.y, TOP_LEFT_CORNER);
        this.drawCorner(this.x + edgeWidth + GuiWindow.getCornerSize(), this.y, TOP_RIGHT_CORNER);
        this.drawCorner(this.x + edgeWidth + GuiWindow.getCornerSize(), this.y + edgeHeight + GuiWindow.getCornerSize(), BOTTOM_RIGHT_CORNER);
        this.drawCorner(this.x, this.y + edgeHeight + GuiWindow.getCornerSize(), BOTTOM_LEFT_CORNER);
        this.drawBackground();
        this.drawComponents();
    }

    @Override
    public void mouseMoved(int mouseX, int mouseY) {
        for (GuiComponent component : this.components) {
            component.mouseMoved(mouseX - this.x, mouseY - this.y);
        }
    }

    public void centerOnScreen() {
        aum res = new aum(this.mc.y, this.mc.c, this.mc.d);
        this.x = (res.a() - this.width) / 2;
        this.y = (res.b() - this.height) / 2;
    }

    public void addComponent(GuiComponent component) {
        this.components.add(component);
    }

    private void drawTexturedRect(int x, int y2, int width, int height, int[] u2, int[] v) {
        float[] uf = new float[]{(float)u2[0] / 16.0f, (float)u2[1] / 16.0f};
        float[] vf = new float[]{(float)v[0] / 16.0f, (float)v[1] / 16.0f};
        GL11.glBegin((int)7);
        GL11.glTexCoord2f((float)uf[0], (float)vf[0]);
        GL11.glVertex2i((int)x, (int)y2);
        GL11.glTexCoord2f((float)uf[0], (float)vf[1]);
        GL11.glVertex2i((int)x, (int)(y2 + height));
        GL11.glTexCoord2f((float)uf[1], (float)vf[1]);
        GL11.glVertex2i((int)(x + width), (int)(y2 + height));
        GL11.glTexCoord2f((float)uf[1], (float)vf[0]);
        GL11.glVertex2i((int)(x + width), (int)y2);
        GL11.glEnd();
    }

    private void drawCorner(int x, int y2, int[][] uv) {
        this.drawTexturedRect(x, y2, GuiWindow.getCornerSize(), GuiWindow.getCornerSize(), uv[0], uv[1]);
    }

    private void drawEdges() {
        int cornerSize = GuiWindow.getCornerSize();
        int edgeWidth = this.getEdgeWidth();
        int edgeHeight = this.getEdgeHeight();
        this.drawTexturedRect(this.x + cornerSize, this.y, edgeWidth, cornerSize, TOP_EDGE[0], TOP_EDGE[1]);
        this.drawTexturedRect(this.x, this.y + cornerSize, cornerSize, edgeHeight, LEFT_EDGE[0], LEFT_EDGE[1]);
        this.drawTexturedRect(this.x + cornerSize, this.y + edgeHeight + cornerSize, edgeWidth, cornerSize, BOTTOM_EDGE[0], BOTTOM_EDGE[1]);
        this.drawTexturedRect(this.x + edgeWidth + cornerSize, this.y + cornerSize, cornerSize, edgeHeight, RIGHT_EDGE[0], RIGHT_EDGE[1]);
    }

    private void drawBackground() {
        int colour = GuiHelper.RGBtoInt(WINDOW_COLOUR[0], WINDOW_COLOUR[1], WINDOW_COLOUR[2]);
        GuiWindow.a((int)(this.x + GuiWindow.getCornerSize()), (int)(this.y + GuiWindow.getCornerSize()), (int)(this.x + this.getEdgeWidth() + GuiWindow.getCornerSize()), (int)(this.y + this.getEdgeHeight() + GuiWindow.getCornerSize()), (int)colour);
    }

    private void drawComponents() {
        GL11.glPushMatrix();
        GL11.glTranslatef((float)this.x, (float)this.y, (float)0.0f);
        for (GuiComponent component : this.components) {
            component.draw();
        }
        GL11.glPopMatrix();
    }

    private static int getCornerSize() {
        return 8;
    }

    private int getEdgeWidth() {
        return this.width - 16;
    }

    private int getEdgeHeight() {
        return this.height - 16;
    }
}

