/*
 * Decompiled with CFR 0.152.
 */
package eb.core.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import eb.core.gui.GuiComponent;
import eb.core.gui.GuiHelper;
import org.lwjgl.input.Keyboard;

@SideOnly(value=Side.CLIENT)
public class GuiTextArea
extends GuiComponent {
    private static final int TEXT_COLOUR = GuiHelper.RGBtoInt(255, 255, 255);
    private atq fontRenderer;
    private String text;
    private int lines;
    private boolean focused;
    private boolean enabled;
    private int cursorCounter;
    private int cursorPosition;
    private int maxLength;

    public GuiTextArea(atq fontRenderer, int x, int y2, int width, int height) {
        this.fontRenderer = fontRenderer;
        this.text = "";
        this.focused = false;
        this.enabled = true;
        this.cursorCounter = 0;
        this.cursorPosition = 0;
        this.maxLength = 100;
        this.setDimensions(x, y2, width, height);
        this.lines = (int)Math.floor((double)(this.height - 2) / (double)fontRenderer.b);
    }

    public void updateCursorCounter() {
        ++this.cursorCounter;
    }

    public void setText(String text) {
        this.text = text.length() > this.maxLength ? text.substring(0, this.maxLength) : text;
    }

    public String getText() {
        return this.text;
    }

    public void setMaxLength(int length) {
        this.maxLength = length;
    }

    public void keyTyped(char key, int keyCode) {
        if (this.focused && this.enabled) {
            switch (keyCode) {
                case 203: {
                    this.moveCursor(-1);
                    break;
                }
                case 205: {
                    this.moveCursor(1);
                    break;
                }
                case 14: {
                    this.removeAt(this.cursorPosition);
                    break;
                }
                case 211: {
                    this.removeAt(this.cursorPosition + 1);
                    break;
                }
                default: {
                    if (!u.a((char)key)) break;
                    String strKey = Character.toString(key);
                    if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                        strKey = strKey.toUpperCase();
                    }
                    this.insertCharacter(this.cursorPosition, strKey);
                }
            }
        }
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        this.setFocused(GuiHelper.pointInRect(mouseX, mouseY, this.x, this.y, this.width, this.height));
        if (this.focused) {
            this.setCursorPosition(this.text.length());
        }
    }

    public void setFocused(boolean focused) {
        this.focused = focused;
        this.cursorCounter = 0;
    }

    public boolean isFocused() {
        return this.focused;
    }

    public void setCursorPosition(int pos) {
        this.cursorPosition = pos;
        this.cursorPosition = Math.min(this.cursorPosition, this.text.length());
        this.cursorPosition = Math.max(this.cursorPosition, 0);
    }

    @Override
    public void draw() {
        if (!this.isVisible()) {
            return;
        }
        GuiTextArea.a((int)(this.x - 1), (int)(this.y - 1), (int)(this.x + this.width + 1), (int)(this.y + this.height + 1), (int)-6250336);
        GuiTextArea.a((int)this.x, (int)this.y, (int)(this.x + this.width), (int)(this.y + this.height), (int)-16777216);
        if (this.text.length() == 0) {
            this.drawCursor(0, 0);
        } else {
            String lineText;
            int currentLine = 0;
            for (int pos = 0; pos < this.text.length(); pos += lineText.length()) {
                lineText = this.fontRenderer.a(this.text.substring(pos), this.width - 5);
                this.drawStringOnLine(lineText, currentLine);
                if ((pos > this.cursorPosition || pos + lineText.length() <= this.cursorPosition) && pos + lineText.length() < this.text.length()) continue;
                this.drawCursor(pos, currentLine);
                if (++currentLine < this.lines) continue;
                break;
            }
        }
    }

    private void drawStringOnLine(String str, int line) {
        this.fontRenderer.a(str, this.x + 4, this.y + line * this.fontRenderer.b + 1, TEXT_COLOUR);
    }

    private void drawCursor(int lineStartPos, int line) {
        if (!this.focused || this.cursorPosition < lineStartPos || this.cursorCounter / 6 % 2 != 0) {
            return;
        }
        int cursorX = this.x + 4;
        if (this.cursorPosition > 0 && this.text.length() > 0) {
            cursorX = this.cursorPosition >= this.text.length() ? (cursorX += this.fontRenderer.a(this.text.substring(lineStartPos))) : (cursorX += this.fontRenderer.a(this.text.substring(lineStartPos, this.cursorPosition)));
        }
        int cursorY = this.y + line * this.fontRenderer.b + 2;
        this.fontRenderer.a("_", cursorX, cursorY, TEXT_COLOUR);
    }

    private void moveCursor(int direction) {
        direction = direction < 0 ? -1 : 1;
        this.setCursorPosition(this.cursorPosition + direction);
    }

    private void removeAt(int position) {
        if (position < 1 || position > this.text.length()) {
            return;
        }
        String temp = this.text;
        this.text = temp.substring(0, position - 1);
        if (position < temp.length()) {
            this.text = this.text + temp.substring(position);
            this.setCursorPosition(this.cursorPosition - 1);
        } else {
            this.setCursorPosition(this.cursorPosition);
        }
    }

    private void insertCharacter(int position, String character) {
        if (this.text.length() != this.maxLength && position >= 0) {
            if (position > this.text.length()) {
                position = this.text.length();
            }
            String temp = this.text;
            this.text = temp.substring(0, position);
            this.text = this.text + character;
            this.text = this.text + temp.substring(position);
            this.setCursorPosition(this.cursorPosition + 1);
        }
    }
}

