/*
 * Decompiled with CFR 0.152.
 */
package eb.core.gui;

import eb.core.gui.GuiComponent;
import eb.core.gui.GuiHelper;
import org.lwjgl.input.Mouse;

public class GuiScrollbar
extends GuiComponent {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    private int mode;
    private int amountScrolled;
    private int scrollbarLength;
    private boolean hover;
    private boolean selected;
    private int deltaMouse;
    private int step;
    private int min;
    private int max;
    private int value;

    public GuiScrollbar(int mode, int step, int min, int max) {
        this.mode = mode;
        this.amountScrolled = 0;
        this.scrollbarLength = 0;
        this.hover = false;
        this.selected = false;
        this.deltaMouse = -1;
        this.step = step;
        this.min = min;
        this.max = max;
        this.value = 0;
    }

    @Override
    public void setDimensions(int x, int y2, int width, int height) {
        super.setDimensions(x, y2, width, height);
        this.updateScrollbarLength();
    }

    public int getValue() {
        return this.value;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
        this.updateScrollbarLength();
    }

    @Override
    public void draw() {
        if (!this.isVisible()) {
            return;
        }
        int[] rect = this.getScrollbarRect();
        if (this.selected || this.hover) {
            GuiScrollbar.a((int)rect[0], (int)rect[1], (int)(rect[0] + rect[2]), (int)(rect[1] + rect[3]), (int)GuiHelper.RGBtoInt(26, 26, 26));
        } else {
            GuiScrollbar.a((int)rect[0], (int)rect[1], (int)(rect[0] + rect[2]), (int)(rect[1] + rect[3]), (int)GuiHelper.RGBtoInt(76, 76, 76));
        }
    }

    public void scroll(int amount) {
        this.amountScrolled += amount;
        this.amountScrolled = Math.max(0, this.amountScrolled);
        this.amountScrolled = this.mode == 0 ? Math.min(this.width - this.scrollbarLength, this.amountScrolled) : Math.min(this.height - this.scrollbarLength, this.amountScrolled);
        this.updateValue();
    }

    @Override
    public void mouseMoved(int mouseX, int mouseY) {
        int[] rect = this.getScrollbarRect();
        if (GuiHelper.pointInRect(mouseX, mouseY, rect[0], rect[1], rect[2], rect[3])) {
            this.hover = true;
            this.selected = Mouse.isButtonDown((int)0);
            if (this.selected) {
                if (this.mode == 0) {
                    this.scroll(mouseX - this.deltaMouse);
                } else {
                    this.scroll(mouseY - this.deltaMouse);
                }
            }
        } else {
            this.hover = false;
            this.selected = false;
        }
        this.deltaMouse = this.mode == 0 ? mouseX : mouseY;
    }

    private int[] getScrollbarRect() {
        if (this.mode == 0) {
            return new int[]{this.x + this.amountScrolled, this.y, this.scrollbarLength, this.height};
        }
        return new int[]{this.x, this.y + this.amountScrolled, this.width, this.scrollbarLength};
    }

    private void updateScrollbarLength() {
        this.scrollbarLength = this.max == 0 ? (this.mode == 0 ? this.width : this.height) : (this.mode == 0 ? (int)((float)this.width * ((float)this.step / (float)this.max)) : (int)((float)this.height * ((float)this.step / (float)this.max)));
    }

    private void updateValue() {
        int[] rect = this.getScrollbarRect();
        float t = 0.0f;
        t = this.mode == 0 ? (float)rect[0] / (float)this.width : (float)rect[1] / (float)this.height;
        this.value = this.min + (int)((float)(this.max - this.min) * t);
    }
}

