/*
 * Decompiled with CFR 0.152.
 */
package eb.core.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import eb.core.gui.GuiComponent;
import eb.core.gui.GuiHelper;
import eb.core.gui.GuiListItem;
import eb.core.gui.GuiScrollbar;
import java.util.ArrayList;

@SideOnly(value=Side.CLIENT)
public class GuiList
extends GuiComponent {
    public static final int ALWAYS = 0;
    public static final int OVERFLOW = 1;
    private ArrayList items = new ArrayList();
    private GuiListItem hover = null;
    private GuiListItem selected = null;
    private boolean drawBackground = true;
    private GuiScrollbar scrollbar;
    private int padding = 0;
    private int scrollbarMode;

    public GuiList(int x, int y2, int width, int height) {
        this.setDimensions(x, y2, width, height);
        this.setupScrollbar();
    }

    public void addItem(GuiListItem item) {
        this.items.add(item);
        this.updateScrollbar();
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void setDrawBackground(boolean draw) {
        this.drawBackground = draw;
    }

    public void setScrollbarMode(int mode) {
        this.scrollbarMode = mode;
        this.updateScrollbar();
    }

    @Override
    public void draw() {
        GuiListItem item;
        if (!this.isVisible()) {
            return;
        }
        if (this.drawBackground) {
            GuiList.a((int)this.x, (int)this.y, (int)(this.x + this.width - this.scrollbar.getWidth()), (int)(this.y + this.height), (int)Integer.MIN_VALUE);
        }
        int itemWidth = this.getItemWidth();
        int currentY = this.y + this.padding;
        for (int i = this.scrollbar.getValue(); i < this.items.size() && currentY + (item = (GuiListItem)this.items.get(i)).getHeight() <= this.y + this.height; ++i) {
            item.draw(this.x + this.padding, currentY, itemWidth);
            currentY += item.getHeight();
        }
        this.scrollbar.draw();
    }

    public GuiListItem getSelected() {
        return this.selected;
    }

    public void mouseClicked(int mouseX, int mouseY, int button) {
        if (button == 0) {
            if (this.selected != null) {
                this.selected.setSelected(false);
            }
            if (this.hover != null) {
                if (this.hover.equals(this.selected)) {
                    this.selected.setSelected(false);
                    this.selected = null;
                } else {
                    this.selected = this.hover;
                    this.selected.setSelected(true);
                }
            }
        }
    }

    @Override
    public void mouseMoved(int mouseX, int mouseY) {
        this.scrollbar.mouseMoved(mouseX, mouseY);
        this.setHoverItem(null);
        if (GuiHelper.pointInRect(mouseX, mouseY, this.x, this.y, this.width, this.height)) {
            int itemWidth = this.getItemWidth();
            int currentY = this.y + this.padding;
            for (GuiListItem item : this.items) {
                if (GuiHelper.pointInRect(mouseX, mouseY, this.x + this.padding, currentY, itemWidth, item.getHeight())) {
                    this.setHoverItem(item);
                    break;
                }
                if ((currentY += item.getHeight()) <= this.y + this.height) continue;
                break;
            }
        }
    }

    public void clear() {
        this.items = new ArrayList();
    }

    private void setupScrollbar() {
        this.scrollbar = new GuiScrollbar(1, 1, 0, 0);
        this.scrollbar.setDimensions(this.x + this.width - 6, this.y, 6, this.height);
        this.scrollbarMode = 0;
    }

    private void setHoverItem(GuiListItem item) {
        if (this.hover != null) {
            this.hover.setMouseOver(false);
        }
        this.hover = item;
        if (this.hover != null) {
            this.hover.setMouseOver(true);
        }
    }

    private int getItemWidth() {
        return this.width - 2 * this.padding - this.scrollbar.getWidth();
    }

    private void updateMaxValue() {
        if (this.items.isEmpty()) {
            this.scrollbar.setMax(0);
            return;
        }
        GuiListItem item = (GuiListItem)this.items.get(0);
        int itemsPerView = (int)Math.floor((double)this.height / (double)item.getHeight());
        int max = Math.max(0, this.items.size() - itemsPerView + 1);
        this.scrollbar.setMax(max);
    }

    private void updateScrollbar() {
        this.updateMaxValue();
        if (this.scrollbarMode == 0) {
            this.scrollbar.setVisible(true);
        } else {
            this.scrollbar.setVisible(this.scrollbar.getMax() >= 1);
        }
    }
}

