/*
 * Decompiled with CFR 0.152.
 */
package eb.core.gui;

import eb.core.gui.GuiComponent;
import eb.core.gui.GuiGridItem;
import java.util.ArrayList;

public class GuiGrid
extends GuiComponent {
    private ArrayList items = new ArrayList();
    private int columns;
    private int padding;

    public GuiGrid(int columns, int x, int y2, int width, int height) {
        super(x, y2, width, height);
        this.columns = columns;
        this.padding = 0;
    }

    public void setPadding(int padding) {
        this.padding = padding;
    }

    public void addItem(GuiGridItem item) {
        this.items.add(item);
    }

    @Override
    public void draw() {
        int currentY = this.y + this.padding;
        for (int i = 0; i < this.items.size(); ++i) {
            int rowHeight = 0;
            int currentX = this.x + this.padding;
            for (int column = 0; i < this.items.size() && column < this.columns; ++i, ++column) {
                GuiGridItem item = (GuiGridItem)this.items.get(i);
                item.draw(currentX, currentY);
                currentX += item.getWidth();
                rowHeight = Math.max(rowHeight, item.getHeight());
            }
            if ((currentY += rowHeight) > this.y + this.height) break;
        }
    }
}

