/*
 * Decompiled with CFR 0.152.
 */
package eb.client.gui;

import eb.client.gui.GuiFileItem;
import eb.client.gui.GuiProcessDialog;
import eb.core.Constants;
import eb.core.EBHelper;
import eb.core.gui.GuiLabel;
import eb.core.gui.GuiList;
import eb.core.gui.GuiWindow;
import eb.core.handlers.GhostHandler;
import eb.macro.SchematicImporter;
import java.io.File;

public class GuiSchematic
extends aul {
    private static final long SIZE_THRESHOLD = 7168L;
    private GuiWindow window;
    private GuiList files;
    private atb importButton;
    private GuiLabel schematicName;
    private GuiLabel sizeWarning;
    private GuiProcessDialog processDialog;
    private SchematicImporter importer = new SchematicImporter();
    private long time = 0L;
    private boolean importing = false;
    private String importingName;
    private int windowPadding = 6;
    private int componentPadding = 2;

    public void A_() {
        this.window = new GuiWindow(176, 166);
        int x = this.window.getX();
        int y = this.window.getY();
        int w = this.window.getWidth();
        int h = this.window.getHeight();
        int buttonWidth = 100;
        int buttonHeight = 20;
        this.files = new GuiList(x + this.windowPadding, y + this.windowPadding, w - 2 * this.windowPadding, h - (20 + this.componentPadding + 2 * this.windowPadding));
        this.files.setPadding(2);
        this.populateFilesList();
        this.importButton = new atb(0, x + w / 2 - 50, this.files.getY() + this.files.getHeight() + this.componentPadding, 100, 20, "Import");
        this.i.add(this.importButton);
        this.sizeWarning = new GuiLabel("Warning: Large schematics can take a long time to import", x + w / 2, y + h + this.componentPadding);
        this.sizeWarning.setCentered(true);
        this.sizeWarning.setVisible(false);
        this.sizeWarning.setColour(255, 0, 0);
        this.processDialog = new GuiProcessDialog("");
        if (this.importing) {
            this.setImporting(true);
        }
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.files.mouseMoved(mouseX, mouseY);
        if (this.importing) {
            this.processDialog.draw();
        } else {
            this.window.draw();
            this.files.draw();
            this.sizeWarning.draw();
            super.a(mouseX, mouseY, partialTicks);
        }
    }

    public void c() {
        if (this.importing) {
            this.processDialog.setProgressText(this.getProgressString());
        }
        if (!this.importing && this.files.getSelected() != null) {
            GuiFileItem selected = this.getSelectedItem();
            long schematicSize = this.getSchematicSize(selected.getName());
            if (schematicSize > 7168L) {
                this.sizeWarning.setVisible(true);
            } else {
                this.sizeWarning.setVisible(false);
            }
        }
        super.c();
    }

    protected void a(int x, int y, int button) {
        this.files.mouseClicked(x, y, button);
        super.a(x, y, button);
    }

    public boolean f() {
        return false;
    }

    protected void a(atb button) {
        if (button.g && button.f == 0 && this.files.getSelected() != null) {
            GuiFileItem selected = this.getSelectedItem();
            this.importingName = selected.getName();
            this.importSchematic(selected.getName());
        }
    }

    private void setImporting(boolean importing) {
        if (importing) {
            this.importing = true;
            this.processDialog.setLabelText(this.importingName);
            this.importer.getMacro().addObserver(this.processDialog);
        } else {
            this.importing = false;
            this.importer.getMacro().deleteObserver(this.processDialog);
        }
    }

    private void importSchematic(String name) {
        final String path = Constants.SCHEMATICS_PATH + name + ".schematic";
        new Thread(new Runnable(){

            @Override
            public void run() {
                GuiSchematic.this.importer.importSchematic(path);
                GuiSchematic.this.setImporting(true);
                GuiSchematic.this.importer.getMacro().optimize();
                GuiSchematic.this.setImporting(false);
                EBHelper.printMessage("Successfully imported " + GuiSchematic.this.importingName);
                GhostHandler.instance().setMacro(GuiSchematic.this.importer.getMacro());
            }
        }).start();
        this.time = System.currentTimeMillis();
    }

    private void populateFilesList() {
        File dir = new File(Constants.SCHEMATICS_PATH);
        if (dir.exists()) {
            this.files.clear();
            for (File file : dir.listFiles()) {
                if (!this.getFileExtension(file.getName()).equals("schematic")) continue;
                this.files.addItem(new GuiFileItem(this.getFileName(file.getName()), ""));
            }
        }
    }

    private String getFileName(String path) {
        int start = path.lastIndexOf(47);
        int end = path.lastIndexOf(46);
        if (start == -1) {
            start = 0;
        }
        if (end == -1) {
            end = path.length() - 1;
        }
        return path.substring(start, end);
    }

    private String getFileExtension(String path) {
        int start = path.lastIndexOf(46);
        if (start == -1) {
            return "";
        }
        return path.substring(start + 1);
    }

    private String getProgressString() {
        String progress = "Optimizing";
        long dt = System.currentTimeMillis() - this.time;
        if (dt > 333L) {
            progress = progress + ".";
        }
        if (dt > 666L) {
            progress = progress + ".";
        }
        if (dt > 999L) {
            progress = progress + ".";
        }
        if (dt > 1332L) {
            this.time = System.currentTimeMillis();
        }
        return progress;
    }

    private long getSchematicSize(String name) {
        String path = Constants.SCHEMATICS_PATH + name + ".schematic";
        return new File(path).length();
    }

    private GuiFileItem getSelectedItem() {
        return (GuiFileItem)this.files.getSelected();
    }
}

