/*
 * Decompiled with CFR 0.152.
 */
package eb.client.gui;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import eb.client.gui.GuiFileItem;
import eb.core.Constants;
import eb.core.EBHelper;
import eb.core.gui.GuiList;
import eb.core.gui.GuiListItem;
import eb.core.gui.GuiScrollbar;
import eb.core.gui.GuiTextArea;
import eb.core.gui.GuiWindow;
import eb.core.handlers.GhostHandler;
import eb.macro.Macro;
import eb.macro.MacroIO;
import java.io.File;

@SideOnly(value=Side.CLIENT)
public class GuiMacro
extends aul {
    private GuiWindow window;
    private GuiList files;
    private GuiList usageList;
    private atn macroName;
    private GuiTextArea macroDesc;
    private atb saveButton;
    private atb loadButton;
    private GuiListItem selected;
    private GuiScrollbar scrollbar;

    public void A_() {
        int padding = 6;
        this.window = new GuiWindow(176, 166);
        this.files = new GuiList(6, 6, this.window.getWidth() - 12, this.window.getHeight() - 60);
        this.files.setPadding(2);
        this.populateFilesList();
        this.window.addComponent(this.files);
        this.usageList = new GuiList(this.window.getWidth() + 6, 6, 48, this.window.getHeight() - 6);
        this.usageList.setPadding(2);
        this.usageList.setDrawBackground(false);
        this.usageList.setScrollbarMode(1);
        this.populateUsageList();
        this.window.addComponent(this.usageList);
        this.macroName = new atn(this.l, this.window.getX() + 6 + 1, this.window.getY() + this.files.getHeight() + 8, this.window.getWidth() - 65, 11);
        this.macroName.b(false);
        this.macroDesc = new GuiTextArea(this.l, 7, this.files.getHeight() + 22, this.window.getWidth() - 65, 33);
        this.macroDesc.setFocused(false);
        this.macroDesc.setMaxLength(65);
        this.window.addComponent(this.macroDesc);
        this.saveButton = new atb(0, this.window.getX() + this.macroDesc.getWidth() + 9, this.window.getY() + this.files.getHeight() + 10, 50, 20, "Save");
        this.loadButton = new atb(1, this.saveButton.c, this.saveButton.d + 22, 50, 20, "Load");
        this.i.add(this.saveButton);
        this.i.add(this.loadButton);
    }

    public void a(int mouseX, int mouseY, float partialTicks) {
        this.window.mouseMoved(mouseX, mouseY);
        this.window.draw();
        this.macroName.f();
        super.a(mouseX, mouseY, partialTicks);
    }

    public void c() {
        GuiListItem item = this.files.getSelected();
        if (item != null && !item.equals(this.selected)) {
            Macro macro;
            this.selected = item;
            GuiFileItem macroItem = (GuiFileItem)item;
            if (!macroItem.isLoaded() && (macro = this.getSelectedMacro()) != null) {
                macroItem.setDescription(macro.getDescription());
                macroItem.setLoaded(true);
            }
            this.macroName.a(macroItem.getName());
            this.macroDesc.setText(macroItem.getDescription());
            this.populateUsageList();
        }
        this.saveButton.e = MacroIO.macroExists(this.macroName.b()) ? "Overwrite" : "Save";
        this.macroName.a();
        this.macroDesc.updateCursorCounter();
        super.c();
    }

    public boolean f() {
        return false;
    }

    protected void a(char key, int keyCode) {
        if (keyCode == 1) {
            this.f.a(null);
            return;
        }
        if (this.macroName.l()) {
            this.macroName.a(key, keyCode);
        } else if (this.macroDesc.isFocused()) {
            this.macroDesc.keyTyped(key, keyCode);
        }
    }

    protected void a(int x, int y, int button) {
        this.files.mouseClicked(x, y, button);
        this.macroName.a(x, y, button);
        this.macroDesc.mouseClicked(x - this.window.getX(), y - this.window.getY(), button);
        super.a(x, y, button);
    }

    protected void a(atb button) {
        if (button.g) {
            if (button.f == 0) {
                if (button.e.equals("Overwrite") && this.selected != null) {
                    ((GuiFileItem)this.selected).setLoaded(false);
                }
                this.saveMacro(this.macroName.b().trim(), this.macroDesc.getText().trim());
            } else if (button.f == 1) {
                this.loadMacro(this.macroName.b().trim());
            }
        }
    }

    private void saveMacro(String name, String description) {
        if (!name.isEmpty()) {
            Macro macro = GhostHandler.instance().getMacro();
            if (macro != null) {
                macro.setName(name);
                macro.setDescription(description);
                MacroIO.save(macro);
            }
            this.populateFilesList();
        }
    }

    private void loadMacro(String name) {
        if (!name.isEmpty()) {
            Macro macro = MacroIO.load(name);
            if (macro != null) {
                GhostHandler.instance().setMacro(macro);
            } else {
                EBHelper.printMessage("Problem loading macro \"" + name + "\"");
            }
        }
    }

    private void populateFilesList() {
        File dir = new File(Constants.MACROS_PATH);
        if (dir.exists()) {
            this.files.clear();
            for (File file : dir.listFiles()) {
                this.files.addItem(new GuiFileItem(this.getMacroName(file.getName()), ""));
            }
        }
    }

    private void populateUsageList() {
    }

    private Macro getSelectedMacro() {
        GuiFileItem item = (GuiFileItem)this.selected;
        return MacroIO.load(item.getName());
    }

    private String getMacroName(String filename) {
        String name = filename.substring(0, filename.lastIndexOf(46));
        name = name.replace("_", " ");
        return name;
    }
}

